/* global sc */
let $$ = require('cdev/debug')({debug: 'cache', path: module.id, prefix: '[isg.xpert.archive]'});
$$.mdb = require('/agorum/roi/customers/cdev.ncore/js/utils/mdb')($$);
// This script is called at the end of the installation
const COUNTER = 'MAIN_MODULE_MANAGEMENT/customers/isg.xpert.archive/counter';
const CONFIG = 'MAIN_MODULE_MANAGEMENT/customers/isg.xpert.archive/config';

// create counter if not exists
let counter = $$.mdb.load(COUNTER);
if (Object.keys(counter).length === 0) {
  $$.mdb.save(COUNTER, { records: 0, documents: 0 });
}

// load config settings from metadb
let config = $$.mdb.load(CONFIG);

// udate default settings from existing config
let newConfig = Object.assign(
  {
    prefix: 'isg_xpert_archive_',
    charset: 'ISO-8859-15',
    blocksize: 3,
    blockcount: 3,
    server: 'http://archiv.mdb.local',
    logging: true,
    debug: true,
    initialize: false,
  },
  config
);

// always set initialize to false
newConfig.initialize = false;

$$.mdb.save(CONFIG, newConfig);
$$.mdb.load(CONFIG);
